/*
  ==============================================================================

    OSCThread.h
    Created: 11 Aug 2013 9:48:42am
    Author:  Niall

  ==============================================================================
*/

#ifndef __OSCTHREAD_H_8D81C28__
#define __OSCTHREAD_H_8D81C28__

#include "../JuceLibraryCode/JuceHeader.h"
#include "NiallsSocketLib/UDPSocket.h"

///	Thread for a single listen port.
class OSCThread : public Thread
{
  public:
	///	Constructor.
	OSCThread(int port);
	///	Destructor.
	~OSCThread();

	///	Where we listen for OSC packets.
	void run();

	///	Sets the listen port.
	void setListenPort(int port);
	///	Returns the listen port.
	int getListenPort() const {return (int)(listenSocket.getPort());};

	///	Adds a send address/port combo.
	void addSendDestination(const String& address, int port);
	///	Removes the indexed send destination.
	void removeSendDestination(const String& address, int port);

	///	Sets the indexed send port.
	void setSendPort(int index, int port);
	///	Sets the indexed send address.
	void setSendAddres(int index, const String& address);

	///	Returns the number of send destinations.
	int getNumSendDestinations() const {return destinations.size();};
	///	Returns the port of the indexed send destination.
	int getSendPort(int index) const {return destinations[index]->getPort();};
	///	Returns the address of the indexed send destination.
	String getSendAddress(int index) const {return String(destinations[index]->getSendAddress().c_str());};
  private:
	///	The socket we listen on.
	UDPSocket listenSocket;

	///	The sockets we send to.
	OwnedArray<UDPSocket> destinations;

	///	Critical section used to protect the sockets when we change their settings.
	CriticalSection critSec;
};

#endif  // __OSCTHREAD_H_8D81C28__
